<?php
/**
 * Fckeditor编辑器，支持代码高亮
 * 
 * @package Fckeditor
 * @author Shion
 * @version 1.0.0
 * @dependence 9.9.2-*
 * @link http://www.shionco.com
 */
class Fckeditor_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        Typecho_Plugin::factory('admin/write-post.php')->richEditor = array('Fckeditor_Plugin', 'render');
        Typecho_Plugin::factory('admin/write-page.php')->richEditor = array('Fckeditor_Plugin', 'render');
        
        Typecho_Plugin::factory('Widget_Contents_Post_Edit')->write = array('Fckeditor_Plugin', 'filter');
        Typecho_Plugin::factory('Widget_Contents_Page_Edit')->write = array('Fckeditor_Plugin', 'filter');
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){}
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}
    
    /**
     * 去除换行符
     * 
     * @access public
     * @param array $post 数据结构体
     * @return array
     */
    public static function filter($post)
    {
        $post['text'] = str_replace(array("\r", "\n"), '', $post['text']);
        return $post;
    }
    
    /**
     * 插件实现方法
     * 
     * @access public
     * @return void
     */
    public static function render($post)
    {
        $options = Helper::options();
        $js = Typecho_Common::url('Fckeditor/fckeditor/fckeditor.js', $options->pluginUrl);
        $path = Typecho_Common::url('Fckeditor/fckeditor/', $options->pluginUrl);
        echo "<script type=\"text/javascript\" src=\"{$js}\"></script>
<script type=\"text/javascript\">
    window.onload = function()
    {
        var oFCKeditor = new FCKeditor( 'text' ) ;
        oFCKeditor.BasePath	= '{$path}' ;
        oFCKeditor.Height = 350 ;
        oFCKeditor.ReplaceTextarea() ;
    }
    var insertImageToEditor = function (title, url, link) {
        var oEditor = FCKeditorAPI.GetInstance('text') ;
        if ( oEditor.EditMode == FCK_EDITMODE_WYSIWYG )
        {
            oEditor.InsertHtml( '<img src=\"' + url + '\" alt=\"' + title + '\" />' ) ;
        }
        else
        {
            alert( '请先切换至编辑模式' ) ;
        }
    };
    var insertLinkToEditor = function (title, url, link, id) {
        var oEditor = FCKeditorAPI.GetInstance('text') ;
        if ( oEditor.EditMode == FCK_EDITMODE_WYSIWYG )
        {
            oEditor.InsertHtml( '<a href=\"' + url + '\" title=\"' + title + '\" >' + title + '</a>' ) ;
        }
        else
        {
            alert( '请先切换至编辑模式' ) ;
        }
    };
</script>";
    }
}
