<?php

class BufannaoWap_EditPost extends Widget_Contents_Post_Edit
{
    /**
     * 执行函数
     *
     * @access public
     * @return void
     */
    public function execute()
    {
		$this->options->loginUrl = Typecho_Common::url('/action/wap-login', $this->options->index);
		parent::execute();
	}

	public function action()
	{
		$this->on($this->request->is('do=publish') || $this->request->is('do=save'))->writePost();
		$this->on($this->request->is('do=delete&cid'))->deletePost();
		$this->on(!$this->request->do)->postForm();
	}

    public function deletePost()
    {
		if($this->request->confirm){
			parent::deletePost();
		}
		else
		{
			Typecho_Widget::widget('Widget_Notice')->to($notice);
			if($notice->have() && in_array($notice->noticeType, array('success', 'notice', 'error')))
			{
				$this->response->redirect($this->options->siteUrl);
			}
			else
			{
				BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>删除文章 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editPost?do=delete', $this->options->index); ?>" method="post" name="delete_post">
<p><input type="checkbox" name="confirm" value="1" /> 已确认<br /><input type="submit" value="<?php _e('提交删除'); ?>" /></p>
<input type="hidden" name="cid" value="<?php echo $this->request->cid; ?>" />
</form>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
			}
		}
	}

    public function writePost()
    {
        $contents = $this->request->from('password', 'allowComment',
        'allowPing', 'allowFeed', 'slug', 'category', 'tags', 'text');
        $contents['type'] = 'post';

        $contents['title'] = $this->request->get('title', _t('未命名文档'));
        $contents['created'] = $this->getCreated();
        $contents = $this->pluginHandle()->write($contents, $this);

        if ($this->request->is('do=publish')) {
            /** 重新发布已经存在的文章 */
            $this->publish($contents);

            /** 发送ping */
            $trackback = array_unique(preg_split("/(\r|\n|\r\n)/", trim($this->request->trackback)));
            $this->widget('Widget_Service')->sendPing($this->cid, $trackback);

        } else {
            /** 保存文章 */
            $this->save($contents);
        }
		$this->response->redirect($this->options->siteUrl);
    }

    public function postForm()
    {
		Typecho_Widget::widget('Widget_Notice')->to($notice);
		Typecho_Widget::widget('Widget_Contents_Post_Edit')->to($post);
		BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>发布文章 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editPost', $this->options->index); ?>" method="post" name="write_post">
<p>标题:<br /><input type="text" name="title" value="<?php echo htmlspecialchars($post->title); ?>" /></p>
<p>内容:<br /><textarea rows="5" name="text"><?php echo htmlspecialchars($post->text); ?></textarea></p>
<p>标签:<br /><input name="tags" type="text" value="<?php $post->tags(',', false); ?>" /></p>
<input type="hidden" name="cid" value="<?php $post->cid(); ?>" />
<p>日期:<br />
<select name="month">
<option value="1" <?php if (1 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('一月'); ?></option>
<option value="2" <?php if (2 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('二月'); ?></option>
<option value="3" <?php if (3 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('三月'); ?></option>
<option value="4" <?php if (4 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('四月'); ?></option>
<option value="5" <?php if (5 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('五月'); ?></option>
<option value="6" <?php if (6 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('六月'); ?></option>
<option value="7" <?php if (7 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('七月'); ?></option>
<option value="8" <?php if (8 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('八月'); ?></option>
<option value="9" <?php if (9 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('九月'); ?></option>
<option value="10" <?php if (10 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十月'); ?></option>
<option value="11" <?php if (11 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十一月'); ?></option>
<option value="12" <?php if (12 == $post->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十二月'); ?></option>
</select>
<input size="4" maxlength="4" type="text" name="day" value="<?php $post->date('d'); ?>" />
,
<input size="4" maxlength="4" type="text" name="year" value="<?php $post->date('Y'); ?>" />
@
<input size="2" maxlength="2" type="text" name="hour" value="<?php $post->date('H'); ?>" />
:
<input size="2" maxlength="2" type="text" name="min" value="<?php $post->date('i'); ?>" />
</p>
<p>分类:<br />
<?php Typecho_Widget::widget('Widget_Metas_Category_List')->to($category); ?>
<?php
if ($post->have()) {
$categories = Typecho_Common::arrayFlatten($post->categories, 'mid');
} else {
$categories = array();
}
?>
<?php while($category->next()): ?>
<input type="checkbox" value="<?php $category->mid(); ?>" name="category[]" <?php if(in_array($category->mid, $categories)): ?>checked="true"<?php endif; ?>/> <?php $category->name(); ?><br />
<?php endwhile; ?>
</p>
<p>缩略名:<br /><input type="text" id="slug" name="slug" value="<?php $post->slug(); ?>" /></p>
<p>密码:<br /><input type="text" id="password" name="password" value="<?php $post->password(); ?>" /></p>
<p>引用通告:<br /><textarea name="trackback" rows="2"></textarea></p>
<p><input name="allowComment" type="checkbox" value="1" <?php if($post->allow('comment')): ?>checked="true"<?php endif; ?> /> <?php _e('允许评论'); ?></p>
<p><input name="allowPing" type="checkbox" value="1" <?php if($post->allow('ping')): ?>checked="true"<?php endif; ?> /> <?php _e('允许被引用'); ?></p>
<p><input name="allowFeed" type="checkbox" value="1" <?php if($post->allow('feed')): ?>checked="true"<?php endif; ?> /> <?php _e('允许在聚合中出现'); ?></p>
<p><input type="radio" name="do" value="publish" checked="checked" /><?php _e('发布文章'); ?><input type="radio" name="do" value="save" /><?php _e('保存草稿'); ?><br /><input type="submit" value="<?php _e('确认提交'); ?>" /></p>
</form>
<p><a href="<?php $this->options->siteUrl(); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
	}
}
