<?php

class BufannaoWap_EditPage extends Widget_Contents_Page_Edit
{
    /**
     * 执行函数
     *
     * @access public
     * @return void
     */
    public function execute()
    {
		$this->options->loginUrl = Typecho_Common::url('/action/wap-login', $this->options->index);
		parent::execute();
	}

	public function action()
	{
		$this->on($this->request->is('do=publish') || $this->request->is('do=save'))->writePage();
		$this->on($this->request->is('do=delete&cid'))->deletePage();
		$this->on(!$this->request->do)->pageForm();
	}

    public function deletePage()
    {
		if($this->request->confirm){
			parent::deletePage();
		}
		else
		{
			Typecho_Widget::widget('Widget_Notice')->to($notice);
			if($notice->have() && in_array($notice->noticeType, array('success', 'notice', 'error')))
			{
				$this->response->redirect($this->options->siteUrl);
			}
			else
			{
				BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>删除页面 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editPage?do=delete', $this->options->index); ?>" method="post" name="delete_page">
<p><input type="checkbox" name="confirm" value="1" /> 已确认<br /><input type="submit" value="<?php _e('提交删除'); ?>" /></p>
<input type="hidden" name="cid" value="<?php echo $this->request->cid; ?>" />
</form>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
			}
		}
	}

    public function writePage()
    {
        $contents = $this->request->from('text', 'template', 'allowComment',
            'allowPing', 'allowFeed', 'slug', 'order');
        $contents['type'] = 'page';

        $contents['title'] = $this->request->get('title', _t('未命名页面'));
        $contents['created'] = $this->getCreated();
        $contents = $this->pluginHandle()->write($contents, $this);

        if ($this->request->is('do=publish')) {
            /** 重新发布已经存在的文章 */
            $this->publish($contents);

            /** 发送ping */
            $this->widget('Widget_Service')->sendPing($this->cid);
        } else {
            /** 保存文章 */
            $this->save($contents);
        }
		$this->response->redirect($this->options->siteUrl);
    }

    public function pageForm()
    {
		Typecho_Widget::widget('Widget_Notice')->to($notice);
		Typecho_Widget::widget('Widget_Contents_Page_Edit')->to($page);
		BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>发布页面 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editPage', $this->options->index); ?>" method="post" name="write_post">
<p>标题:<br /><input type="text" name="title" value="<?php echo htmlspecialchars($page->title); ?>" /></p>
<p>内容:<br /><textarea rows="5" name="text"><?php echo htmlspecialchars($page->text); ?></textarea></p>
<input type="hidden" name="cid" value="<?php $page->cid(); ?>" />
<p>日期:<br />
<select name="month">
<option value="1" <?php if (1 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('一月'); ?></option>
<option value="2" <?php if (2 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('二月'); ?></option>
<option value="3" <?php if (3 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('三月'); ?></option>
<option value="4" <?php if (4 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('四月'); ?></option>
<option value="5" <?php if (5 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('五月'); ?></option>
<option value="6" <?php if (6 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('六月'); ?></option>
<option value="7" <?php if (7 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('七月'); ?></option>
<option value="8" <?php if (8 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('八月'); ?></option>
<option value="9" <?php if (9 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('九月'); ?></option>
<option value="10" <?php if (10 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十月'); ?></option>
<option value="11" <?php if (11 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十一月'); ?></option>
<option value="12" <?php if (12 == $page->date->format('n')): ?>selected="true"<?php endif; ?>><?php _e('十二月'); ?></option>
</select>
<input size="4" maxlength="4" type="text" name="day" value="<?php $page->date('d'); ?>" />
,
<input size="4" maxlength="4" type="text" name="year" value="<?php $page->date('Y'); ?>" />
@
<input size="2" maxlength="2" type="text" name="hour" value="<?php $page->date('H'); ?>" />
:
<input size="2" maxlength="2" type="text" name="min" value="<?php $page->date('i'); ?>" />
</p>
<p>缩略名:<br /><input type="text" id="slug" name="slug" value="<?php $page->slug(); ?>" /></p>
<p>页面顺序:<br /><input type="text" name="order" value="<?php $page->order(); ?>" /></p>
<p><input name="allowComment" type="checkbox" value="1" <?php if($page->allow('comment')): ?>checked="true"<?php endif; ?> /> <?php _e('允许评论'); ?></p>
<p><input name="allowPing" type="checkbox" value="1" <?php if($page->allow('ping')): ?>checked="true"<?php endif; ?> /> <?php _e('允许被引用'); ?></p>
<p><input name="allowFeed" type="checkbox" value="1" <?php if($page->allow('feed')): ?>checked="true"<?php endif; ?> /> <?php _e('允许在聚合中出现'); ?></p>
<p><input type="radio" name="do" value="publish" checked="checked" /><?php _e('发布页面'); ?><input type="radio" name="do" value="save" /><?php _e('保存草稿'); ?><br /><input type="submit" value="<?php _e('确认提交'); ?>" /></p>
</form>
<p><a href="<?php $this->options->siteUrl(); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
	}
}
