<?php

class BufannaoWap_EditComment extends Widget_Comments_Edit
{
	public function action()
	{
		$this->on($this->request->is('do=edit&coid'))->editComment();
		$this->on($this->request->is('do=delete&coid'))->deleteComment();
		$this->on($this->request->is('do=approved&coid'))->approvedComment();
		$this->on(!$this->request->do)->approvedList();
	}

	public function editComment()
	{
		if($this->request->submit){
			$coid = $this->request->filter('int')->coid;
			$commentSelect = $this->db->fetchRow($this->select()->where('coid = ?', $coid)->limit(1), array($this, 'push'));

			if ($commentSelect && $this->commentIsWriteable()) {

				$comment['text'] = $this->request->text;
				$comment['author'] = $this->request->filter('strip_tags', 'trim', 'xss')->author;
				$comment['mail'] = $this->request->filter('strip_tags', 'trim', 'xss')->mail;
				$comment['url'] = $this->request->filter('url')->url;

				/** 更新评论 */
				$this->update($comment, $this->db->sql()->where('coid = ?', $coid));
			}
			$this->response->redirect($this->options->siteUrl);
		}
		else
		{
			$coid = $this->request->filter('int')->coid;
			$this->db->fetchRow($this->select()->where('coid = ?', $coid)->limit(1), array($this, 'push'));
			BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>编辑评论 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editComment?do=edit', $this->options->index); ?>" method="post" name="edit_comment">
<p>名称:<br /><input name="author" type="text" value="<?php echo $this->author; ?>" /></p>
<p>电子邮件:<br /><input name="mail" type="text" value="<?php echo $this->mail; ?>" /></p>
<p>个人主页:<br /><input name="url" type="text" value="<?php echo $this->url; ?>" /></p>
<p><textarea rows="3" name="text"><?php echo $this->text; ?></textarea></p>
<p><input type="submit" value="<?php _e('保存评论'); ?>" /></p>
<input type="hidden" name="coid" value="<?php echo $this->request->coid; ?>" />
<input type="hidden" name="submit" value="1" />
</form>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
		}
	}

	public function deleteComment()
	{
		if($this->request->confirm){
			parent::deleteComment();
		}
		else
		{
			Typecho_Widget::widget('Widget_Notice')->to($notice);
			if($notice->have() && in_array($notice->noticeType, array('success', 'notice', 'error')))
			{
				$this->response->redirect($this->options->siteUrl);
			}
			else
			{
				BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>删除评论 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editComment?do=delete', $this->options->index); ?>" method="post" name="delete_comment">
<p><input type="checkbox" name="confirm" value="1" /> 已确认<br /><input type="submit" value="<?php _e('提交删除'); ?>" /></p>
<input type="hidden" name="coid" value="<?php echo $this->request->coid; ?>" />
</form>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
			}
		}
	}

	public function approvedComment()
	{
		if($this->request->confirm){
			parent::approvedComment();
		}
		else
		{
			Typecho_Widget::widget('Widget_Notice')->to($notice);
			if($notice->have() && in_array($notice->noticeType, array('success', 'notice', 'error')))
			{
				$this->response->redirect(Typecho_Common::url('/action/wap-editComment', $this->options->index));
			}
			else
			{
				BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
</style>
<title>审核评论 - <?php $this->options->title(); ?></title>
</head>
<body>
<form action="<?php echo Typecho_Common::url('/action/wap-editComment?do=approved', $this->options->index); ?>" method="post" name="approved_comment">
<p><input type="checkbox" name="confirm" value="1" /> 已确认<br /><input type="submit" value="<?php _e('审核通过'); ?>" /></p>
<input type="hidden" name="coid" value="<?php echo $this->request->coid; ?>" />
</form>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
			}
		}
	}

	public function approvedList()
	{
		Typecho_Widget::widget('Widget_Comments_Admin', '', 'status=waiting')->to($comments);
		BufannaoWap_Plugin::wapHeader();
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Cache-control" content="no-cache" />
<style type="text/css">
.headline {clear:both;background:#e4f2fd; font-weight:bold; padding:8px 5px;border-bottom: 1px solid #c6d9e9;}
.page-navigator {background: #f5f5f5;width:100%;zoom:1;}
.page-navigator li {float:left;display:inline-block;padding:5px;}
.page-navigator li a { color:#d54e21;}
.page-navigator li.current a { color:#333333;}
</style>
<title>待审核评论列表 - <?php $this->options->title(); ?></title>
</head>
<body>
<div id="approvedlist">
<div class="headline">待审核评论列表</div>
<div>
<?php if($comments->have()): ?>
<?php while($comments->next()): ?>
评论人:<?php $comments->author(true); ?><br />
<?php if($comments->mail): ?>电子邮件:<?php $comments->mail(); ?><?php endif; ?><br />
<?php if($comments->ip): ?>IP:<?php $comments->ip(); ?><?php endif; ?><br />
评论内容:<br /><?php $comments->content(); ?><br />
评论时间:<?php $comments->dateWord(); ?><br />
评论文章：<a href="<?php $comments->permalink(); ?>"><?php $comments->title(); ?></a><br />
评论管理：<a href="<?php echo Typecho_Common::url('/action/wap-editComment?do=approved&coid='.$comments->coid, Helper::options()->index); ?>">审核</a>&nbsp;|&nbsp;<a href="<?php echo Typecho_Common::url('/action/wap-editComment?do=edit&coid='.$comments->coid, Helper::options()->index); ?>">编辑</a>&nbsp;|&nbsp;<a href="<?php echo Typecho_Common::url('/action/wap-editComment?do=delete&coid='.$comments->coid, Helper::options()->index); ?>">删除</a>
<hr />
</div>
<?php endwhile; ?>
<ul class="page-navigator">
<?php $comments->pageNav(); ?>
</ul>
<?php else: ?>
<p><?php _e('没有待审核评论') ?></p>
<?php endif; ?>
</div>
<p><a href="<?php echo htmlspecialchars($this->request->get('referer', $this->options->siteUrl)); ?>"><?php _e('&laquo; 返回%s', $this->options->title); ?></a></p>
</body>
</html>
<?php
	}
}
