<?php
/**
 * 拖拽图形验证码插件（基于<a href="http://www.webdesignbeach.com/beachbar/ajax-fancy-captcha-jquery-plugin">AJAX FANCY CAPTCHA</a>并参照<a href="http://typecho.org/archives/54/">Typecho Captcha</a>开发）
 * 
 * @package FancyCaptcha
 * @author 小强
 * @version 1.0.0
 * @link http://bufannao.com
 */
class FancyCaptcha_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->header = array('FancyCaptcha_Plugin', 'header');
        Typecho_Plugin::factory('Widget_Feedback')->comment = array('FancyCaptcha_Plugin', 'filter');
        Typecho_Plugin::factory('Widget_Feedback')->trackback = array('FancyCaptcha_Plugin', 'filter');
        Typecho_Plugin::factory('Widget_XmlRpc')->pingback = array('FancyCaptcha_Plugin', 'filter');
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
		$formId = new Typecho_Widget_Helper_Form_Element_Text('formId',NULL,'comment_form','验证码所应用于表单的ID值', '请务必根据主题实际修改。');
		$form->addInput($formId);

		$borderColor = new Typecho_Widget_Helper_Form_Element_Text('borderColor',NULL,'silver','验证码边框颜色', '请根据主题实际修改，如黑色：#000000');
		$form->addInput($borderColor);

		$text = new Typecho_Widget_Helper_Form_Element_Text('text',NULL,'为防止恶意评论,<br />请拖动 <span>指定图形</span> 到圆形区域里.','验证码提示文字', '当前已改为中文，非特殊情况不需更改。');
		$form->addInput($text);

		$items = new Typecho_Widget_Helper_Form_Element_Text('items',NULL,'pencil,scissors,clock,heart,note','验证码应用图片英文名', '多个图形用逗号分隔，默认为5种图型，非特殊情况不需更改。');
		$form->addInput($items);

		$cnItems = new Typecho_Widget_Helper_Form_Element_Text('cnItems',NULL,'铅笔,剪刀,时钟,红心,音符','验证码应用图片对应中文名', '与英文名相对应，非特殊情况不需更改。');
		$form->addInput($cnItems);
	
	}
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 头部样式
     *
     * @access public
     * @param unknown $headlink
     * @return unknown
     */
    public static function header() {
        $plugin_url = Helper::options()->pluginUrl .'/FancyCaptcha';
		$settings = Helper::options()->plugin('FancyCaptcha');
		$header = '';
		// 加载Jquery
		$header .=  '<script type="text/javascript" src="'.$plugin_url.'/jquery-1.5.1.min.js"></script>'."\n";

		// 加载JqueryUI
		$header .=  '<script type="text/javascript" src="'.$plugin_url.'/jquery-ui-1.8.10.custom.min.js"></script>'."\n";

		// 加载captcha.js
		$header .=  '<script type="text/javascript" src="'.$plugin_url.'/jquery.captcha.js"></script>'."\n";

		// 加载captcha.css
		$header .= '<link rel="stylesheet" type="text/css" href="'.$plugin_url.'/captcha.css" />';

		$header .= '<script type="text/javascript" charset="utf-8">
		$(function() {
			$(".ajax-fc-container").captcha({
				borderColor: "'.$settings->borderColor.'",
				formId : "'.$settings->formId.'",
				captchaDir : "'.$plugin_url.'",
				url: "'.$plugin_url.'/captcha.php",
				text: "'.$settings->text.'",
				items: Array("'.str_replace(array(',', '，'), '","', $settings->items).'"),
				cnItems: Array("'.str_replace(array(',', '，'), '","', $settings->cnItems).'")
			});
		});
	</script>';

		echo $header;
    }

    public static function output()
    {
        echo '<div class="ajax-fc-container">You must enable javascript to see captcha here!</div>';
    }
    
    /**
     * 评论过滤器
     * 
     * @access public
     * @param array $comment 评论结构
     * @param Typecho_Widget $post 被评论的文章
     * @param array $result 返回的结果上下文
     * @param string $api api地址
     * @return void
     */
    public static function filter($comment, $post, $result)
    {
        $captchaCode = Typecho_Request::getInstance()->captcha;
        if (empty($captchaCode)) {
            throw new Typecho_Widget_Exception(_t('请输入验证码'));
        }

        if ($captchaCode != $_SESSION['captcha']) {
			unset($_SESSION['captcha']);
			throw new Typecho_Widget_Exception(_t('验证码错误, 请重新输入'));
		}

        return $comment;
    }
}
