<?php
/* 异步执行的发送文件
 *
 *
 */
ignore_user_abort(true);
set_time_limit(0);
require_once('class.phpmailer.php');
$dir='./cache/';
if(isset($_GET['mail']) && !empty ($_GET['mail'])){
    $file=$dir.base64_decode($_GET['mail']);
    $smtp= unserialize(gzinflate(file_get_contents($file)));
    //替换评论状态为中文
    switch($smtp->status) {
        case "approved":
            $smtp->status='通过';
            break;
        case "waiting":
            $smtp->status='待审';
            break;
        case "spam":
            $smtp->status='垃圾';
            break;
    }
    //设置本次评论是否接收邮件
    if($smtp->banMail) proveParent ($smtp->coid, True);
    
    //向博主发信
    if(!empty ($smtp->toOwner)){  
        mixMail($smtp,'owner');        
        send($smtp);
    }
    //向访客发信
    if(!empty ($smtp->toGuest) && $smtp->toOwner!=$smtp->toGuest && proveParent($smtp->parent)){
        mixMail($smtp,'guest');        
        send($smtp);
      
    }
    $smtp=null; 
    @unlink($file);
}

//组合邮件内容
function mixMail($smtp,$to='owner'){
    $d=getdate($smtp->created);
    $time = $d['year']."年".$d['mon']."月".$d['mday']."日".$d['hours'].":".$d['minutes'].":".$d['seconds'];
        
    if('owner'==$to){
        $subject=(empty ($smtp->ownerSubject))?'[{site}]:《{title}》有了新的评论':$smtp->ownerSubject;
        $body=(empty ($smtp->ownerBody))?file_get_contents('./log/owner.html'):$smtp->ownerBody;        
        $search=array('{site}','{title}','{author}','{ip}','{mail}','{permalink}','{manage}','{text}','{time}','{status}');
        $replace=array($smtp->site,$smtp->title,$smtp->author,$smtp->ip,$smtp->mail,$smtp->permalink,$smtp->manage,$smtp->text,$time,$smtp->status);
        $smtp->to=$smtp->toOwner;   
    }
   
    if('guest'==$to){
        $subject=(empty ($smtp->guestSubject))?'[{site}]:《{title}》有了新的评论':$smtp->guestSubject;
        $body=(empty ($smtp->guestBody))?file_get_contents('./log/guest.html'):$smtp->guestBody;
        $search=array('{site}','{title}','{author_p}','{author}','{mail}','{permalink}','{text}','{text_p}','{time}');
        $replace=array($smtp->site,$smtp->title,$smtp->originalAuthor,$smtp->author, $smtp->mail,$smtp->permalink,$smtp->text,$smtp->originalText,$time); 
        $smtp->to=$smtp->toGuest;        
    }    
    
    $smtp->body=str_replace($search, $replace, $body);
    $smtp->subject=str_replace($search, $replace, $subject);
    $smtp->AltBody="作者：".$smtp->author."\r\n链接：".$smtp->permalink."\r\n评论：\r\n".$smtp->text;
    
}

//发送函数
function send($smtp){
    $mail  = new PHPMailer();
    $mail->CharSet = "UTF-8";
    $mail->Encoding = 'base64';
    switch ($smtp->mode)
    {
        case 'mail':
            break;
        case 'sendmail':
            $mail->IsSendmail();
            break;
        case 'smtp':
            $mail->IsSMTP();
            if($smtp->validate) $mail->SMTPAuth   = true;
            if($smtp->ssl) $mail->SMTPSecure = "ssl";
            $mail->Host       = $smtp->host;
            $mail->Port       = $smtp->port;
            $mail->Username   = $smtp->user;
            $mail->Password   = $smtp->pass;
            $smtp->from=$smtp->user;
            break;
    }
    $mail->SetFrom($smtp->from, $smtp->site);
    $mail->AddReplyTo($smtp->to,$smtp->site);
    $mail->Subject    = $smtp->subject;
    $mail->AltBody    = $smtp->AltBody;
    $mail->MsgHTML($smtp->body);
    
    $mail->AddAddress($smtp->to,$smtp->originalAuthor);
    
   
   
    if(!$mail->Send()){
        $msg = date("Y-m-d H:i:s")." 向 ".$smtp->to." 发送邮件错误: " . $mail->ErrorInfo."\r\n";
        file_put_contents('./log/error_log.txt', $msg);
    } 
    
    if($smtp->maillog) { 
        $msg = $msg ? $msg : date("Y-m-d H:i:s")." 向 ".$smtp->to." 发送邮件成功！\r\n";
        $file = "./log/mail_log.txt";
        $fp = @fopen($file,'a+');
        fwrite($fp,$msg);
        fclose($fp);        
    }
    $mail=NULL;
}

//验证原评论者是否接收评论
function proveParent($parent,$write=false){
    if($parent){
        $index=ceil($parent/500);
        $filename="./log/ban_".$index.".list";
               
        if(!file_exists($filename)){
            file_put_contents($filename, "a:0:{}");
        }
        
        $list=unserialize(file_get_contents($filename));        
        //写入记录
        if($write){
            $list[$parent]=1;
            file_put_contents($filename,serialize($list));
            return TRUE;
        }
        //判读记录是否存在，存在则返回false，不存在返回true表示接收邮件
        if(!$write && 1==$list[$parent]){
            return false;
        }else{
            return TRUE;
        }
        
    } else {
        return false;
    }
}
?>
