# 📚 AIBaTgrMX - AI 智能内容助手

## 🌟 产品简介

AIBaTgrMX 是一款专业的 Typecho AI 内容助手插件，基于先进的 AI 模型，为博客创作者提供智能化的内容处理解决方案。本插件支持 DeepSeek、OpenAI 等主流 AI 服务，提供文章摘要生成、智能标签推荐等核心功能。

### 🎯 核心特性

- **🤖 智能内容分析**: 深度理解文章内容，提供精准的内容处理
- **🚀 高性能架构**: 异步处理 + 多级缓存，确保快速响应
- **🛡️ 安全可靠**: 内置多重安全机制，保护 API 密钥和数据安全
- **🔄 灵活配置**: 支持自定义 AI 模型、提示词和处理规则
- **📊 数据驱动**: 提供详细的 API 调用统计和性能分析

---

## 📦 系统要求

- PHP >= 7.2.0
- Typecho >= 1.2.0
- PHP 扩展：curl、json、mbstring、pdo
- 内存限制：>= 256MB（推荐）
- 磁盘空间：>= 10MB

---

## 🚀 快速开始

### 📥 安装步骤

1. **下载插件**
   ```bash
   git clone https://github.com/Master08s/Typecho-AIBaTgrMX.git
   ```

2. **上传文件**
   - 将插件目录上传至 `usr/plugins/AIBaTgrMX`
   - 确保目录权限设置正确（建议 755）

3. **插件启用**
   - 进入 Typecho 后台 → 插件管理
   - 找到 `AIBaTgrMX` → 点击启用
   - 根据提示完成初始化配置

### ⚙️ 基础配置

1. **API 设置**
   ```yaml
   提供商选择:
     - DeepSeek API (推荐)
     - OpenAI API
     - 自定义 API
   
   必填参数:
     - API 密钥
     - 模型选择
     - 自定义接口地址(可选)
   ```

2. **功能模块**
   ```yaml
   核心功能:
     - 文章摘要: 自动/手动生成
     - 智能标签: 最多10个/文章
   ```

3. **性能设置**
   ```yaml
   缓存配置:
     - 缓存时间: 1-72小时
     - 清理周期: 自动/手动
     
   并发控制:
     - 最大任务数: 3
     - 超时时间: 30秒
   ```

---

## 🛠️ 高级功能

### 📝 自定义提示词系统

1. **摘要生成**
   ```yaml
   变量支持:
     - {{LANGUAGE}}: 输出语言
     - {{MAX_LENGTH}}: 最大长度
     
   优化建议:
     - 保持提示词结构化
     - 明确质量控制指标
     - 设定处理优先级
   ```

2. **标签生成**
   ```yaml
   核心参数:
     - {{MAX_TAGS}}: 标签数量
     - {{LANGUAGE}}: 输出语言
     
   处理流程:
     - 文本分析
     - 关键词提取
     - 标签优化
   ```

### 🔄 异步处理机制

```php
处理流程:
1. 任务入队
2. 异步处理
3. 结果缓存
4. 回调通知
```

### 🛡️ 安全机制

```yaml
安全特性:
  - API密钥加密存储
  - 请求频率限制
  - 数据验证过滤
  - 错误重试机制
```

---

## 📊 性能优化

### 缓存策略

```yaml
多级缓存:
  - 内存缓存: 热点数据
  - 文件缓存: 常规数据
  - 数据库缓存: 持久数据

清理机制:
  - 定时清理
  - 容量控制
  - 手动触发
```

### 并发控制

```yaml
限制机制:
  - 最大并发数: 3
  - 队列优先级: 3级
  - 超时处理: 30s
```

---

## 🔍 故障排除

### 常见问题

1. **API 调用失败**
   ```yaml
   排查步骤:
     1. 验证API密钥
     2. 检查网络连接
     3. 查看错误日志
     4. 确认额度限制
   ```

2. **性能问题**
   ```yaml
   优化方案:
     1. 调整缓存设置
     2. 优化并发参数
     3. 检查服务器负载
     4. 清理历史数据
   ```

3. **内容质量**
   ```yaml
   改进措施:
     1. 优化提示词
     2. 调整模型参数
     3. 增加质量检查
     4. 人工审核
   ```

---

## 📈 版本更新

### v2.2 最新更新


- 🔄 优化异步处理机制和并发逻辑
- 🛡️ 增强安全性检查
- 🚀 提升缓存性能
- 🔧 修复已知问题

### v2.1 更新

- 🗃️ 支持 SQLite 数据库
- 🔄 优化并发处理逻辑
- 🚀 改进异步任务处理
- 🐛 修复个人设置页面访问报错
- ⚡ 性能优化和代码重构

### v2.0 更新

- 🎯 首次发布
- 🤖 集成 AI 内容处理功能
- 🔄 异步处理支持
- 📦 缓存系统
- 🛡️ 基础安全机制
- 🆕 支持 DeepSeek API

---

## 🤝 技术支持

- 📧 邮箱：hb111Aa@icloud.com
- 🌐 官网：https://blog.tgrmx.cn
- 💬 开源：https://github.com/Master08s/Typecho-AIBaTgrMX

---

## 📜 开源协议

本项目采用 MIT 协议开源，详见 [LICENSE](LICENSE) 文件。

---

⚠️ **免责声明**：本插件依赖第三方 AI 服务，使用前请确保遵守相关服务条款和法律法规。插件作者不对因使用本插件造成的任何损失负责。