<?php
/**
 * 评论回复邮件提醒插件的SAE版
 *
 * @package CommentToMail-sae
 * @author DEFE
 * @version 1.2.4
 * @link http://defe.me
 */
class CommentToMail_Plugin implements Typecho_Plugin_Interface {
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {
        Typecho_Plugin::factory('Widget_Feedback')->finishComment = array('CommentToMail_Plugin', 'toMail');
        return _t('请对插件进行正确设置，以使插件顺利工作！') . $error;
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate() {

    }

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form) {

        $cfg_host = new Typecho_Widget_Helper_Form_Element_Text('cfg_host', NULL, 'smtp.',
                _t('SMTP地址'), _t('请填写 SMTP 服务器地址'));
        $form->addInput($cfg_host->addRule('required', _t('必须填写一个SMTP服务器地址')));

        $cfg_port = new Typecho_Widget_Helper_Form_Element_Text('cfg_port', NULL, '25',
                _t('SMTP端口'), _t('SMTP服务端口,一般为25。'));
        $cfg_port->input->setAttribute('class', 'mini');
        $form->addInput($cfg_port->addRule('required', _t('必须填写SMTP服务端口'))
                ->addRule('isInteger', _t('端口号必须是纯数字')));

        $cfg_user = new Typecho_Widget_Helper_Form_Element_Text('cfg_user', NULL, NULL,
                _t('SMTP用户'),_t('SMTP服务验证用户名,一般为邮箱名如：youname@domain.com'));
        $form->addInput($cfg_user->addRule('required', _t('SMTP服务验证用户名')));

        $cfg_pass = new Typecho_Widget_Helper_Form_Element_Password('cfg_pass', NULL, NULL,
                _t('SMTP密码'));
        $form->addInput($cfg_pass->addRule('required', _t('SMTP服务验证密码')));

        $cfg_validate=new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_validate',
                array('validate'=>'服务器需要验证',
                    'ssl'=>'ssl加密'),
                array('validate'),'SMTP验证');
        $form->addInput($cfg_validate);

        $cfg_mail = new Typecho_Widget_Helper_Form_Element_Text('cfg_mail', NULL, NULL,
                _t('接收邮箱'),_t('接收邮件用的信箱,如为空则使用博客创建者个人设置中的邮箱！'));
        $form->addInput($cfg_mail->addRule('email', _t('请填写正确的邮箱！')));

        $cfg_send = new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_send',
                array('approved' => '提醒已通过评论',
                        'waiting' => '提醒待审核评论',
                        'spam' => '提醒垃圾评论'),
                array('approved', 'waiting'), '提醒设置');
        $form->addInput($cfg_send);

        $cfg_other = new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_other',
                array('to_me' => '有评论及回复时，发邮件通知博主。',
                    'to_other' => '评论被回复时，发邮件通知评论者。'),
                array('to_me', 'to_other' ), '其他设置',_t('暂时没有日志功能。'));
        $form->addInput($cfg_other->multiMode());

        $cfg_title = new Typecho_Widget_Helper_Form_Element_Text('cfg_title',null,"[{site}]:《{title}》一文有新的评论",
                _t('邮件标题'));
        $form->addInput($cfg_title);

        $cfg_title1 = new Typecho_Widget_Helper_Form_Element_Text('cfg_title1',null,"[{site}]:您在《{title}》一文的评论有了回复",
                _t('回复评论者邮件标题'));
        $form->addInput($cfg_title1);

    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form) {

    }

    /**
     * 组合邮件内容
     *
     * @access public
     * @param $post 调用参数
     * @return void
     */
    public static function toMail($post) {
        date_default_timezone_set('Asia/Chongqing');
        $db = Typecho_Db::get();
        $options = Typecho_Widget::widget('Widget_Options');
        $site = $options->title;
        $settings = Helper::options()->plugin('CommentToMail');
        $smtp=array();
        $smtp['ssl'] = false;
        $smtp['site']=$site;

        /**获取SMTP设置*/
        $smtp['user'] = $settings->cfg_user;
        $smtp['pass'] = $settings->cfg_pass;
        $smtp['host'] = $settings->cfg_host;
        $smtp['port'] = $settings->cfg_port;

        //获取验证信息
        if(in_array('validate',$settings->cfg_validate)) $smtp['validate']=true;
        if(in_array('ssl',$settings->cfg_validate)) $smtp['ssl']=true;

        /**评论被回复时，发信通知评论者*/
        if(0!=$post->parent && in_array($post->status,$settings->cfg_send) && in_array('to_other',$settings->cfg_other)) {
            $select=$db->select('author','mail','text')
                    ->from('table.comments')
                    ->where('coid = ?', $post->parent);
            $result = $db->query($select);
            $row = $db->fetchRow($result);

            $smtp['to']=$row['mail'];

            if($row['mail']!=$post->mail) {

                /**取得标题格式*/
                if($settings->cfg_title1){
                    $title1=$settings->cfg_title1;
                }else{
                    $title1="[".$site."]:您在《".$post->title."》的评论有了回复";
                }

                /**取得邮件主体格式*/

               $format1=file_get_contents("./usr/plugins/CommentToMail/guest.html");

                $search1=array('{site}','{title}','{author_p}','{author}','{ip}','{mail}','{permalink}','{text}','{text_p}');
                $replace1=array($site,$post->title,$row['author'],$post->author,$post->ip,$post->mail,$post->permalink,$post->text,$row['text']);
                $smtp['body']=str_replace($search1, $replace1, $format1);
                $smtp['subject']=str_replace($search1, $replace1, $title1);

                self::SendMail($smtp);
            }
        }

        /**发信到博主信箱*/
        if(in_array($post->status,$settings->cfg_send) && $post->ownerId!=$post->authorId && in_array('to_me',$settings->cfg_other)) {
            /**格式化评论发布时间*/
            $d=getdate($post->created);
            $times = $d['year']."年".$d['mon']."月".$d['mday']."日".$d['hours'].":".$d['minutes'].":".$d['seconds'];

            /**评论状态*/
            switch($post->status) {
                case "approved":
                    $sta='<font color="#008040">已通过</font>';
                    break;
                case "waiting":
                    $sta='<font color="#FF8000">待审核</font>';
                    break;
                case "spam":
                    $sta='<font color="#FF0000">垃圾</font>';
                    break;
            }
            /**管理评论链接*/
            $manage= $options->siteUrl."admin/manage-comments.php";

            /**获取邮件正文格式*/
           $format=file_get_contents("./usr/plugins/CommentToMail/owner.html");

            /**处理邮件正文*/
            $search=array('{site}','{title}','{author}','{ip}','{mail}','{permalink}','{manage}','{text}','{time}','{status}');
            $replace=array($site,$post->title,$post->author,$post->ip,$post->mail,$post->permalink,$manage,$post->text,$times,$sta);
            $smtp['body']=str_replace($search, $replace, $format);

            /**邮件标题*/
            if($settings->cfg_title){
                $title=$settings->cfg_title;
            }else{
                $title="[{site}]:《{title}》一文有新的评论";
            }
            $smtp['subject']=str_replace($search, $replace, $title);


            /**获取接收邮箱*/
            if($settings->cfg_mail!="") {
                $email_to=$settings->cfg_mail;
            }else {
                $select=Typecho_Widget::widget('Widget_Abstract_Users')->select()->where('uid',1);
                $result = $db->query($select);
                $row = $db->fetchRow($result);
                $email_to=$row['mail'];
            }

            $smtp['to']=$email_to;
            $smtp['from']=$email_to;

        }

        self::SendMail($smtp);
     }

     /**
     * 发送邮件
     *
     * @access public
     * @param string $filename 存放邮件的临时文件名
     * @param string $siteUrl 网站连接
     * @return void
     */
    public static function SendMail($smtp) {

       $mail = new SaeMail();
       $mail->setOpt( array( 'content_type'=>"HTML") );
       $re = $mail->quickSend($smtp['to'], $smtp['subject'], $smtp['body'], $smtp['user'], $smtp['pass'], $smtp['host'], $smtp['port']);
      if ($ret === false){
        var_dump($mail->errno(), $mail->errmsg());
      }
    }
}
