<?php
/* 异步执行的发送文件
 *
 *
 */
ignore_user_abort(true);
set_time_limit(0);
$dir='./cache/';
if(isset($_GET['mail']) && !empty ($_GET['mail'])){
    $file=$dir.base64_decode($_GET['mail']);
    $smtp= unserialize(mcode(file_get_contents($file)));
    //替换评论状态为中文
    switch($smtp->status) {
        case "approved":
            $smtp->status='通过';
            break;
        case "waiting":
            $smtp->status='待审';
            break;
        case "spam":
            $smtp->status='垃圾';
            break;
    }
    //设置本次评论是否接收邮件
    if($smtp->banMail) proveParent ($smtp->coid, True);
    
    //向博主发信
    if(!empty ($smtp->toOwner)){  
        mixMail($smtp,'owner');        
        send($smtp);
    }
    //向访客发信
    if(!empty ($smtp->toGuest) && $smtp->toOwner!=$smtp->toGuest && proveParent($smtp->parent)){
        mixMail($smtp,'guest');        
        send($smtp);
      
    }
    $smtp=null; 
    @unlink($file);
}

//组合邮件内容
function mixMail($smtp,$to='owner'){
    $d=getdate($smtp->created);
    $time = $d['year']."年".$d['mon']."月".$d['mday']."日".$d['hours'].":".$d['minutes'].":".$d['seconds'];
        
    if('owner'==$to){
        $subject=(empty ($smtp->ownerSubject))?'[{site}]:《{title}》有了新的评论':$smtp->ownerSubject;
        $body=(empty ($smtp->ownerBody))?file_get_contents('./log/owner.html'):$smtp->ownerBody;        
        $search=array('{site}','{title}','{author}','{ip}','{mail}','{permalink}','{manage}','{text}','{time}','{status}');
        $replace=array($smtp->site,$smtp->title,$smtp->author,$smtp->ip,$smtp->mail,$smtp->permalink,$smtp->manage,$smtp->text,$time,$smtp->status);
        $smtp->to=$smtp->toOwner;   
    }
   
    if('guest'==$to){
        $subject=(empty ($smtp->guestSubject))?'[{site}]:《{title}》有了新的评论':$smtp->guestSubject;
        $body=(empty ($smtp->guestBody))?file_get_contents('./log/guest.html'):$smtp->guestBody;
        $search=array('{site}','{title}','{author_p}','{author}','{mail}','{permalink}','{text}','{text_p}','{time}');
        $replace=array($smtp->site,$smtp->title,$smtp->originalAuthor,$smtp->author, $smtp->mail,$smtp->permalink,$smtp->text,$smtp->originalText,$time); 
        $smtp->to=$smtp->toGuest;        
    }    
    
    $smtp->body=str_replace($search, $replace, $body);
    $smtp->subject=str_replace($search, $replace, $subject);
    $smtp->AltBody="作者：".$smtp->author."\r\n链接：".$smtp->permalink."\r\n评论：\r\n".$smtp->text;
    
}

//发送函数
function send($smtp){    
    require('class.phpmailer.php');
    $mail  = new PHPMailer();
    $mail->CharSet = "UTF-8";
    $mail->Encoding = 'base64';
    switch ($smtp->mode)
    {
        case 'mail':
            break;
        case 'sendmail':
            $mail->IsSendmail();
            break;
        case 'smtp':
            $mail->IsSMTP();
            if($smtp->validate) $mail->SMTPAuth   = true;
            if($smtp->ssl) $mail->SMTPSecure = "ssl";
            $mail->Host       = $smtp->host;
            $mail->Port       = $smtp->port;
            $mail->Username   = $smtp->user;
            $mail->Password   = $smtp->pass;
            $smtp->from=$smtp->user;
            break;
    }
    $mail->SetFrom($smtp->from, $smtp->site);
    $mail->AddReplyTo($smtp->to,$smtp->site);
    $mail->Subject    = $smtp->subject;
    $mail->AltBody    = $smtp->AltBody;
    $mail->MsgHTML($smtp->body);
    
    $mail->AddAddress($smtp->to,$smtp->originalAuthor);
    
   
   
    if(!$mail->Send()){
        $msg = date("Y-m-d H:i:s")." 向 ".$smtp->to." 发送邮件错误: " . $mail->ErrorInfo."\r\n";
        file_put_contents('./log/error_log.txt', $msg);
    } 
    
    if($smtp->maillog) { 
        $msg = $msg ? $msg : date("Y-m-d H:i:s")." 向 ".$smtp->to." 发送邮件成功！\r\n";
        $file = "./log/mail_log.txt";
        $fp = @fopen($file,'a+');
        fwrite($fp,$msg);
        fclose($fp);        
    }
    $mail=NULL;
}

//验证原评论者是否接收评论
function proveParent($parent,$write=false){
    if($parent){
        $index=ceil($parent/500);
        $filename="./log/ban_".$index.".list";
               
        if(!file_exists($filename)){
            file_put_contents($filename, "a:0:{}");
        }
        
        $list=unserialize(file_get_contents($filename));        
        //写入记录
        if($write){
            $list[$parent]=1;
            file_put_contents($filename,serialize($list));
            return TRUE;
        }
        //判读记录是否存在，存在则返回false，不存在返回true表示接收邮件
        if(!$write && 1==$list[$parent]){
            return false;
        }else{
            return TRUE;
        }
        
    } else {
        return false;
    }
}

 function mcode($string, $operation = 'DECODE', $key = '', $expiry = 60) {

         $ckey_length = 7;
         $key = md5($key ? $key : 'comment_to_mail'); //这里可以填写默认key值
         $keya = md5(substr($key, 0, 16));
         $keyb = md5(substr($key, 16, 16));
         $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

         $cryptkey = $keya.md5($keya.$keyc);
         $key_length = strlen($cryptkey);

         $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
         $string_length = strlen($string);

         $result = '';
         $box = range(0, 255);

         $rndkey = array();
         for($i = 0; $i <= 255; $i++) {
             $rndkey[$i] = ord($cryptkey[$i % $key_length]);
         }

         for($j = $i = 0; $i < 256; $i++) {
             $j = ($j + $box[$i] + $rndkey[$i]) % 256;
             $tmp = $box[$i];
             $box[$i] = $box[$j];
             $box[$j] = $tmp;
         }

         for($a = $j = $i = 0; $i < $string_length; $i++) {
             $a = ($a + 1) % 256;
             $j = ($j + $box[$a]) % 256;
             $tmp = $box[$a];
             $box[$a] = $box[$j];
             $box[$j] = $tmp;
             $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
         }

         if($operation == 'DECODE') {
             if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
                 return substr($result, 26);
             } else {
                 return '';
             }
         } else {
             return $keyc.str_replace('=', '', base64_encode($result));
         }

     }
?>
