<?php

class Digg_Action extends Typecho_Widget implements Widget_Interface_Do
{
    public function __construct($request, $response, $params = NULL)
    {
        parent::__construct($request, $response, $params);
    }

    /**
     * 计数
     * 
     */
    public function count()
    {
        //只允许ajax Post提交
        if (!$this->request->isPost() || !$this->request->isAjax()) $this->error(405, 'Method Not Allowed');

        $db = Typecho_Db::get();
        //获取设置中的项目
        $_items = explode("|", Helper::options()->plugin('Digg')->items);

        $cid = (int)$this->request->cid;
        $item = $this->request->action;
        //参数缺失
        if (empty($cid)||empty($item)) $this->error(405, 'Param Missed');
        //提交的项目在设置中不存在
        if (!in_array($item, $_items)) $this->error(405, 'Param Wrong');

        $result = $db->fetchRow($db->select('digg')->from('table.contents')->where('cid = ?', $cid));
        //日志不存在
        if (empty($result)) $this->error(405, 'Post Not Found');

        $result['digg'] = empty($result['digg']) ? array() : unserialize($result['digg']);

        if (array_key_exists($item,$result['digg'])) {
            $result['digg'][$item] ++;
        } else {
            $result['digg'][$item] = 1;
        }
        //清除过期项目
        foreach($result['digg'] as $k => $v) {
            if (!in_array($k, $_items)) unset($result['digg'][$k]);
        }
        //更新数据库
        $db->query($db->update('table.contents')->rows(array('digg' => serialize($result['digg'])))->where('cid = ?', $cid));
        //设置已digg标记cookie
        $cookie = Array (
            'name'   => '__typecho_digg_' . $cid, 
            'expire' => 2592000,
        );
        Typecho_Cookie::set($cookie['name'], Helper::options()->gmtTime, Helper::options()->gmtTime + $cookie['expire'], Helper::options()->siteUrl);
        $this->response->throwJson('Digg Success');
    }

    public function error($code, $msg=NULL)
    {
        //$this->response->setStatus($code); // Issue 551 已经修复，请更新最新svn版本
        header('HTTP/1.1 405 Method Not Allowed',true,$code);
        if ($msg) $this->response->throwJson($msg);
        exit;
    }

    /**
     * 绑定动作
     *
     * @access public
     * @return void
     */
    public function action(){

        $this->count();
    }
}
?>
