<?php
/**
 * 能赚钱的验证码。技术支持地址：http://aikvn.com/archives/18.html。
 * 
 * @package 印象码
 * @author aikvn
 * @version 1.1.0
 * @link http://aikvn.com
 */
class Captcha_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        if (!function_exists('gd_info')) {
            throw new Typecho_Plugin_Exception(_t('对不起, 您的主机不支持 gd 扩展, 无法正常使用此功能'));
        }
    
        Typecho_Plugin::factory('Widget_Feedback')->comment = array('Captcha_Plugin', 'filter');
        Typecho_Plugin::factory('Widget_Feedback')->trackback = array('Captcha_Plugin', 'filter');
        Typecho_Plugin::factory('Widget_XmlRpc')->pingback = array('Captcha_Plugin', 'filter');
        
        Helper::addAction('captcha', 'Captcha_Action');
		
		$fileList = getDirlist($dir . 'fonts');
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){}
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}
    
    public static function output()
    {
        require_once("YinXiangMaLib.php");
		echo YinXiangMa_GetYinXiangMaWidget();
    }
    
    /**
     * 评论过滤器
     * 
     * @access public
     * @param array $comment 评论结构
     * @param Typecho_Widget $post 被评论的文章
     * @param array $result 返回的结果上下文
     * @param string $api api地址
     * @return void
     */
    public static function filter($comment, $post, $result)
    {
        require_once("YinXiangMaLib.php");
		$YinXiangMa_response = new YinXiangMaResponse();
		$YinXiangMa_response=YinXiangMa_validRequest($_POST[YinXiangMa_response],$_POST[YinXiangMa_challenge]);
		if($YinXiangMa_response->is_valid == "true")
		{
			return $comment;
		}
		else
		{
			throw new Typecho_Widget_Exception(_t('验证码错误, 请重新输入'));
			echo $YinXiangMa_response->error;
		}
		
		$captchaCode = Typecho_Request::getInstance()->captcha_code;
        if (empty($captchaCode)) {
            throw new Typecho_Widget_Exception(_t('请输入验证码'));
        }
    }
}




function getDirlist($dirPath) {
	$fileList = array();

	if ( ($dh = opendir($dirPath)) !== false) {
		while (($file = readdir($dh)) !== false) {
			if ($file != '.' && $file != '..') {
				$fileList[$file] = $file;
			}
		}
		closedir($dh);
	}

	return $fileList;
}