/*
 * TextEditor 实现类
 * @package TextEditor
 * @author vfasky
 * @version 0.3.1
 * @link http://vfasky.9diary.com
 */


var TextEditorCore = function( elId )
{
    /** 闭包 **/
    var _self = this;

    /** 上下文 **/
    var _conext = {};

    /** 编辑器容器 **/
    var _textarea = $( elId );

    /** 记录已生成的窗口 **/
    var _win = [];
    
    /** 取编辑器选择的文本 **/
    this.getTextareaSelectText = function()
    {
        var range  = _textarea.getSelectedRange();
        var text   = _textarea.get('value');
        return text.substr(range.start, range.end - range.start);
    }

    /** 添加多行标签 **/
    this.addMultiLineTagEvent = function(leftTag , rightTag)
    {
        _textarea.focus();
        var range  = _textarea.getSelectedRange();
        var text   = _textarea.get('value');
        var before = text.substr(0, range.start);
        var center = text.substr(range.start, range.end - range.start);
        var after  = text.substr(range.end);

        var multiLine = center.split(/\r?\n/);
        center        = '';

        multiLine.each( function(v){
            if( '' != v )
                center += '<li>' + v + '</li>' + '\r\n';
        } );

        _textarea.set('value', before + leftTag + '\r\n' + center  + rightTag + after);
        var pos = before.length + leftTag.length;
        if (range.start != range.end)
        {
            pos += center.length + rightTag.length;
        }
        _textarea.selectRange(pos, pos);
    }

    /** 以弹窗方式构造连接 **/
    this.addLinkTagEvent = function()
    {
        if( undefined == _win['linkWin'] )
        {
            var form = new ( _self.form )();
            form.add( _self.form_element_input('连接地址', 'linkSrc') )
            form.add( _self.form_element_input('连接名称', 'linkName' ) )

            _win['linkWin'] = new ( _self.window )( {
                                    title   : '插入连接:' ,
                                    height  : 180 ,
                                    element : form.build( function( data ){
                                        _win['linkWin'].close();
                                        _self.addTagEvent( '<a target="_blank" href="' + data.linkSrc + '">' + data.linkName + '</a>' , '')
                                    } )
                                  } )
        }
        else
        {
            _win['linkWin'].open();
        }
        _win['linkWin'].elm.getElement('input[name=linkName]').set('value' , _self.getTextareaSelectText() );
    }

    /** 以弹窗方式构造图片 **/
    this.addImgTagEvent = function()
    {
        if( undefined == _win['imgWin'] )
        {
            var form = new ( _self.form )();
            form.add( _self.form_element_input('图片地址', 'imgSrc') )
            form.add( _self.form_element_input('图片描述', 'imgDesc') )

            _win['imgWin'] = new( _self.window )( {
                                    title   : '插入图片:' ,
                                    height  : 180 ,
                                    element : form.build( function( data ){
                                        _win['imgWin'].close();
                                        _self.addTagEvent( '<img src="' + data.imgSrc + '" alt="' + data.imgDesc + '" />' , '')
                                    } )
                                  } )
        }
        else
        {
            _win['imgWin'].open();
        }
        _win['imgWin'].elm.getElement('input[name=imgDesc]').set('value' , _self.getTextareaSelectText() );
    }


    /** 添加代码 **/
    this.addCodeHighlight = function()
    {
        if( undefined != this[ 'addCodeHighlight_' + _conext.highlight ] )
        {
            this[ 'addCodeHighlight_' + _conext.highlight ]();
        }
    }

    /** 不使用代码高亮 **/
    this.addCodeHighlight_none = function()
    {
         this.addTagEvent('<pre>' , '</pre>');
    }

    /** 添加 lighter 代码高亮 **/
    this.addCodeHighlight_lighter = function()
    {

        if( undefined == _win['codeHighlightWin'] )
        {
            var form = new ( _self.form )();

            form.add( _self.form_element_select('代码', 'codeType' , 'html' , '' , [
                { lable : 'html' , value : 'html' } ,
                { lable : 'php' , value : 'php' } ,
                { lable : 'css' , value : 'css' } ,
                { lable : 'js' , value : 'js' } ,
                { lable : 'md' , value : 'md' } ,
                { lable : 'sql' , value : 'sql' } ,
                { lable : 'shell' , value : 'shell' } ,
                { lable : 'ruby' , value : 'ruby' } 
            ]) );

            form.add( _self.form_element_select('风格', 'codeStyle' , 'tutti' , '' , [
                { lable : 'tutti' , value : 'tutti' } ,
                { lable : 'git' , value : 'git' } ,
                { lable : 'panic' , value : 'panic' } ,
                { lable : 'twilight' , value : 'twilight' } ,
                { lable : 'standard' , value : 'standard' } ,
                { lable : 'mocha' , value : 'mocha' }
            ]) );


            _win['codeHighlightWin'] = new( _self.window )( {
                                        title   : '插入代码高亮:' ,
                                        height  : 180 ,
                                        element : form.build( function( data ){
                                            _win['codeHighlightWin'].close();
                                            _self.addTagEvent( '<pre class="'+ data.codeType + ':' + data.codeStyle +'">' , '</pre>')
                                        } )
                                      } )
        }
        else
        {
            _win['codeHighlightWin'].open();
        }
    }
    
    /** 添加普通标签**/
    this.addTagEvent = function(leftTag, rightTag)
    {
        _textarea.focus();
        var range  = _textarea.getSelectedRange();
        var text   = _textarea.get('value');
        var before = text.substr(0, range.start);
        var center = text.substr(range.start, range.end - range.start);
        var after  = text.substr(range.end);
        _textarea.set('value', before + leftTag + center + rightTag + after);
        var pos = before.length + leftTag.length;
        if (range.start != range.end)
        {
            pos += center.length + rightTag.length;
        }
        _textarea.selectRange(pos, pos);
    }

    /** 构造工具条 **/
    this.buildTool = function()
    {
        this.tool = new Element('div', {
            'id': 'TextEditorTool'
        });
        this.tool.inject( _textarea , 'before');

        return this;
    }

    /** 间隔 **/
    this.addSpacedToTool = function()
    {
        this.tool.grab( new Element('div', {
            'class' : 'toolSpaced'
        }) );
        return this;
    }

    /** 向工具条添加按钮 **/
    this.addButtonToTool = function( buttonObj )
    {
        var button = $merge({
            'tip'   : '' ,
            'title' : '' ,
            'id'    : '',
            'class' : 'toolButton' ,
            'style' : {} ,
            'callback' : function(){}
        } , buttonObj );

        var elm = new Element('div', {
                'html'  : '<span class="buttonSpan">' + button.title + '</span>' ,
                'class' : button['class'] ,
                'id'    : button.id ,
                'title' : button.tip
        })
        .addEvent('mouseenter' , function(){

        })
        .addEvent('mouseleave' , function(){

        })
        .addEvent('click' , function(){
            button.callback();
        })

        elm.getElement('.buttonSpan').setStyles( button.style );

        this.tool.grab( elm );

        return this;
    }



    /** 弹窗 **/
    this.window = function( config )
    {
        config = ( config || {} );

        var _config = $merge( {
            'title'   : '' ,
            'width'   : 300 ,
            'height'  : 150 ,
            'element' : new Element('div')
        } , config );

        var html = '<div class="TextEditorWindow_close">X</div>'
                 + '<div class="TextEditorWindow_title">' + _config.title + '</div>'

        var _window = new Element('div' , {'html' : html , 'class' : 'TextEditorWindow'})

        var size = _textarea.getSize();

        _window.setStyles( {
                    width  : _config.width + 'px' ,
                    height : _config.height + 'px' ,
                    left   : ( size.x - 350 ) + 'px' ,
                    top    : ( size.y + 0 ) + 'px' ,
                    'position' : 'absolute'
                } )
               .grab( _config.element )
 
        _window.getElement('.TextEditorWindow_close')
               .addEvent('click' , function(){
                   _window.setStyle('display' , 'none');
               })
 
        $(document).getElement('body').grab( _window );

        this.elm = _window;

        this.close = function(){
            _window.setStyle('display' , 'none');
        }

        this.open = function(){
            _window.setStyle('display' , 'block');
        }

        return this;
    }


    /** 表单对象 **/
    this.form = function()
    {
        /** 表单元素 **/
        _element = [];

        /** 添加元素 **/
        this.add = function( element )
        {
            _element[ _element.length ] = element;
        }

        /** 构造表单 **/
        this.build = function( callbcak )
        {
            var form = new Element('form');

            _element.each(function(v){
                form.grab( v );
            });

            form.grab( new Element('div' , {
                'class' : 'footer' ,
                'html' : '<button type="submit">' + '确认' + '</button>'
            }) )

            /** 绑定提交事件 **/
            form.addEvent('submit' , function( event ){
                event.stop();
                var data = {};
                _element.each(function(v){
                    var id   = v.get('id');
                    var elm  = v.getElement( v.get('elementType') + '[name='+id+']');
                    data[id] = elm.get('value')
                    elm.set('value' , '');
                });
                callbcak( data );
            })

            return form;
        }
    }

    /** 表单元素 input 对象 **/
    this.form_element_input = function( lable , id , value , desc )
    {
        desc  = ( desc || '' );
        value = ( value || '' )

        var elmId = 'TextEditorFormElement_'+ id ;
        var html  = '<lable for="'+ elmId +'" class="typecho-label">' + lable + '</lable>'
                  + '<p><input type="text" id="'+ elmId +'" name="'+ id +'" value="" class="text" /></p>';

        if( '' != desc )
        {
            html += '<p class="description">'+desc+'</p>';
        }

        return new Element('div' , {'id' : id , 'html' : html , 'elementType' : 'input'});
    }

    /** 表单元素 select 对象 **/
    this.form_element_select = function( lable , id , value , desc , item )
    {
        desc  = ( desc || '' );
        value = ( value || '' );
        item  = ( item || [] );

        var elmId  = 'TextEditorFormElement_'+ id ;
        var option = '';

        item.each( function(v){
            option += v.value == value
                      ? '<option selected="selected" value="'+ v.value +'">' + v.lable + '</option>'
                      : '<option value="'+ v.value +'">' + v.lable + '</option>';

        } )

        var html  = '<lable for="'+ elmId +'" class="typecho-label">' + lable + '</lable>'
                  + '<p><select id="'+ elmId +'" name="'+ id +'" class="text">' + option + '</p>';

        if( '' != desc )
        {
            html += '<p class="description">'+desc+'</p>';
        }

        return new Element('div' , {'id' : id , 'html' : html , 'elementType' : 'select'});

    }

    /** 热键事件 **/
    this.hotKeyCallback =
    {
        /** 粗体 **/
        'b' : function() {_self.addTagEvent('<strong>' , '</strong>')}
        ,
        /** 粗体 **/
        'i' : function() {_self.addTagEvent('<em>' , '</em>')}
        ,
        /** 删除线 **/
        'd' : function() {_self.addTagEvent('<del>' , '</del>')}
        ,
        /** 连接 **/
        'l' : function() {_self.addLinkTagEvent()}
        ,
        /** 图片 **/
        'g' : function() {_self.addImgTagEvent()}
        ,
        /** hr **/
        'h' : function() {_self.addTagEvent('\r\n<hr/>\r\n' , '')}
        ,
        /** more **/
        'm' : function() {_self.addTagEvent('\r\n<!--more-->\r\n' , '')}
        ,
        /** 圆点列表 **/
        'u' : function() {_self.addMultiLineTagEvent('<ul>' , '</ul>')}
        ,
        /** 编号列表 **/
        'o' : function() {_self.addMultiLineTagEvent('<ol>' , '</ol>')}
        ,
        /** 换行 **/
        'enter' : function() {_self.addTagEvent('\r\n<p></p>' , '')}
        ,
        /** code **/
        'n' : function() {_self.addCodeHighlight()}
    }
 
    /** 热键控制 **/
    this.controlHotKey = function( event )
    {   
        if( event.shift )
        {//alert( event.code )
            if( undefined != this.hotKeyCallback[ event.key ] )
            {
                event.stop();
                this.hotKeyCallback[ event.key ]();
            }
  
        }
    }

    /** 绑定flash上传**/
    this.bindSwfupload = function()
    {
        /** 加入flash容器 **/
        var _d  = $(document);
        _d.getElement('#uploadButton').grab( new Element('div' , {
            'id'    : 'swfuploadBox' ,
            'style' : 'position: absolute; left: 0; top: 0; height:26px; width:26px;' ,
            'html'  : '<span id="swfuploadBoxWrap"></span>'
        }) );

        var fileDialogComplete = function (numFilesSelected, numFilesQueued) {
            try {
                this.startUpload();
            } catch (ex)  {
                this.debug(ex);
            }
        };

        var uploadStart = function (file) {
            if( _d.getElement('#upload-panel').getStyle('display') == 'none' )
            {
                _d.getElement('span.attach').fireEvent('click');
            }

            var _el = new Element('li', {
                'class' : 'upload-progress-item clearfix',
                'id'    : file.id,
                'text'  : file.name
            });

            _el.inject($(document).getElement('ul.upload-progress'), 'top');
            new Fx.Scroll(window).toElement($(document).getElement('ul.upload-progress'));



        };

        var uploadSuccess = function (file, serverData) {
            var _el = $(document).getElement('#' + file.id);
            var _result = JSON.decode(serverData);

            _el.set('html', '<strong>' + file.name +
            '<input type="hidden" name="attachment[]" value="' + _result.cid + '" /></strong>' +
            '<small><span class="insert">插入</span>' +
            ' , <span class="delete">删除</span></small>');
            _el.set('tween', {duration: 1500});

            _el.setStyles({
                'background-image' : 'none',
                'background-color' : '#D3DBB3'
            });

            _el.tween('background-color', '#D3DBB3', '#FFFFFF');

            var _insertBtn = _el.getElement('.insert');
            if (_result.isImage) {
                _insertBtn.addEvent('click', function () {
                    insertImageToEditor(_result.title, _result.url, _result.permalink);
                });
            } else {
                _insertBtn.addEvent('click', function () {
                    insertLinkToEditor(_result.title, _result.url, _result.permalink);
                });
            }
            _insertBtn.fireEvent('click');

            var _deleteBtn = _el.getElement('.delete');
            _deleteBtn.addEvent('click', function () {
                deleteAttachment(_result.cid, this);
            });
        };

        var uploadComplete = function (file) {
            //console.dir(file);
        };

        var uploadError = function (file, errorCode, message) {
            var _el = $(document).getElement('#' + file.id);
            var _fx = new Fx.Tween(_el, {duration: 3000});

            _el.set('html', '<strong>' + file.name + ' 上传失败</strong>');
            _el.setStyles({
                'background-image' : 'none',
                'color'            : '#FFFFFF',
                'background-color' : '#CC0000'
            });

            _fx.addEvent('complete', function () {
                _el.destroy();
            });

            _fx.start('background-color', '#CC0000', '#F7FBE9');
        };

        var uploadProgress = function (file, bytesLoaded, bytesTotal) {
            var _el = $(document).getElement('#' + file.id);
            var percent = Math.ceil((1 - (bytesLoaded / bytesTotal)) * _el.getSize().x);
            _el.setStyle('background-position', '-' + percent + 'px 0');
        };

        var swfu, _size = $(document).getElement('.typecho-list-operate a.button').getCoordinates(),
        settings = {
            flash_url : _conext.swfCofing.flashUrl ,
            upload_url: _conext.swfCofing.uploadUrl ,
            post_params: _conext.swfCofing.postParams,
            file_size_limit : _conext.swfCofing.sizeLimit,
            file_types : _conext.swfCofing.fileTypes,
            file_types_description : _conext.swfCofing.TypesDescription,
            file_upload_limit : 0,
            file_queue_limit : 0,
            debug: false,

            //Handle Settings
            file_dialog_complete_handler : fileDialogComplete,
            upload_start_handler : uploadStart,
            upload_progress_handler : uploadProgress,
            upload_success_handler : uploadSuccess,
            queue_complete_handler : uploadComplete,
            upload_error_handler : uploadError,

            // Button Settings
            button_placeholder_id : "swfuploadBoxWrap",
            button_height: 26,
            button_width: 26,
            button_text: '',
            button_text_style: '',
            button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
            button_cursor: SWFUpload.CURSOR.HAND
        };

        swfu = new SWFUpload(settings);
 
    }

    /** 设置flash 上传配置 **/
    this.setSwfUploadConfig = function( config )
    {
        _conext.swfCofing = config;
        return this;
    }
    
    /** 设置自定义按钮 **/
    this.setUserButton = function( config )
    {
        _conext.userButton = config;
        return this;
    }

    /** 加入自定义按钮 **/
    this.addUserButton = function()
    {
        _conext.userButton.each( function( v ) {
            _self.addButtonToTool( {title : v.title  , callback : function(){ _self.addTagEvent( v.leftTag , v.rightTag ) } } );
        })
        return this;
    }

    /** 设置亮亮插件 **/
    this.setHighlight = function( highlight )
    {
        _conext.highlight = highlight
        return this;
    }

    this.init = function( baseDir )
    {
        
        /** 绑定 keypress **/
        _textarea.addEvent('keypress', function( event ){
            _self.controlHotKey( event );
        });

        this.buildTool()
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat 0 0'} , tip : '粗体(shift+b)' , callback : this.hotKeyCallback.b} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -60px 0'} , tip : '斜体(shift+i)' , callback : this.hotKeyCallback.i} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -120px -1px'} , tip : '删除线(shift+d)' , callback : this.hotKeyCallback.d} )
            .addSpacedToTool()
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -380px 0'} , tip : '插入图片(shift+g)' , callback : this.addImgTagEvent} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -499px 0'} , tip : '插入连接(shift+l)' , callback : this.addLinkTagEvent} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -22px -40px'} , tip : '上传文件' , callback : function(){} , id : 'uploadButton'} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -19px 0'} , tip : '插入无序列表(shift+u)' , callback : this.hotKeyCallback.u} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -79px 0'} , tip : '插入编号列表(shift+o)' , callback : this.hotKeyCallback.o} )
            .addSpacedToTool()
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -360px 0'} , tip : '插入横线(shift+h)' , callback : this.hotKeyCallback.h} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat -920px -21px'} , tip : '插入代码(shift+n)' , callback : this.hotKeyCallback.n} )
            .addButtonToTool( {style : {background : 'url(' + baseDir + 'css/icons.gif) no-repeat 0 -39px'} , tip : '插入择要分隔符(shift+m)' , callback : this.hotKeyCallback.m} )       
            .addSpacedToTool()
            .addUserButton()
            .bindSwfupload()
        
    }
}


