<?php
/**
 * Text编辑器:支持代码高亮,自定义按钮,基于mootools 带上传功能 <br/>
 * 代码高亮默认关闭,需在设置中开启
 * 
 * @package Text编辑器
 * @author vfasky<vfasky@gmail.com>
 * @version 0.3.3
 * @link http://vfasky.9diary.com/
 */

class TextEditor_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 插件版本号
     * @var string
     */
    const _VERSION = '0.3.3';

    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {
        /** js & css 加载 */
        Typecho_Plugin::factory('admin/write-post.php')->bottom = array('TextEditor_Plugin', 'writeBottom');
        Typecho_Plugin::factory('admin/write-page.php')->bottom = array('TextEditor_Plugin', 'writeBottom');

        /** 加入高亮插件 **/
        Typecho_Plugin::factory('Widget_Archive')->header = array('TextEditor_Plugin', 'header');
    }
 
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate() {}



    /**
     * 输出js
     */
    public static function header()
    {
        $options = Helper::options();

        if( $options->plugin('TextEditor')->highlight == 'lighter' )
        {
            $options = Helper::options();
            $jsUrl   = Typecho_Common::url('TextEditor/js/Lighter/Lighter.js' , $options->pluginUrl);
            //不输出后台mootools路径,以免暴露后台路径. 用 cdn 更低碳
            if( 'true' == $options->plugin('TextEditor')->loadMootools )
            {
                echo '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/mootools/1.2.4/mootools-yui-compressed.js"></script>';
            }
            echo '<script type="text/javascript" src="'.$jsUrl.'"></script>';
            echo '<script type="text/javascript"> window.addEvent("domready", function() { $$("pre").light({ mode: "ol" ,altLines: "hover" });  })</script> ';
        }

    
    }

    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        //自定义按钮
        $buttons = new Typecho_Widget_Helper_Form_Element_Textarea(  'buttons',
                                                                      NULL,
                                                                      " br , <br/> \n p , <p> , </p> \n",
                                                                      _t('自定义按键'),
                                                                      _t('按键参数用逗号隔开，多个按键请用换行符隔开')
                                                                   );

        //高亮插件选项
        $highlight = new Typecho_Widget_Helper_Form_Element_Select( 'highlight' ,
                                                                    array( 'none' => '不使用' , 'lighter' => 'lighter' ) ,
                                                                    'none' ,
                                                                    _t('高亮插件'),
                                                                    _t('如果你需要代码高亮,请选择一个插件')
                                                                  );

        //是否使用插件的mootools框架
        $loadMootools = new Typecho_Widget_Helper_Form_Element_Select( 'loadMootools' ,
                                                                    array( 'true' => '使用' , 'false' => '不使用' ) ,
                                                                    'true' ,
                                                                    _t('使用插件的mootools'),
                                                                    _t('如果你已经加载mootools,则不需要重复加载')
                                                                  );

        $form->addInput( $buttons );
        $form->addInput( $highlight );
        $form->addInput( $loadMootools );
    }

    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

 
    /**
     * 初始化编辑器
     */
    public function writeBottom()
    {
        $options = Helper::options();
        $jsUrl   = Typecho_Common::url('TextEditor/js/core.js?' . TextEditor_Plugin::_VERSION , $options->pluginUrl);
        $cssUrl  = Typecho_Common::url('TextEditor/css/style.css' , $options->pluginUrl);
        $baseDir = Typecho_Common::url('TextEditor/' , $options->pluginUrl);

        $val  = trim(ini_get('upload_max_filesize'));
        $last = strtolower($val[strlen($val)-1]);
        switch($last)
        {
            case 'g':
                $val *= 1024;
            case 'm':
                $val *= 1024;
            case 'k':
                $val *= 1024;
        }

        $attachmentTypes      = $options->allowedAttachmentTypes;
        $attachmentTypesCount = count($attachmentTypes);
        $fileTypes            = '';
        for ($i = 0; $i < $attachmentTypesCount; $i ++)
        {
            $fileTypes .= '*.' . $attachmentTypes[$i];
            if ($i < $attachmentTypesCount - 1)
            {
                $fileTypes .= ';';
            }
        }

        /** 格式化用户按钮 **/
        $buttonArr     = array();
        $buttonConfigs = explode( '<br />' , nl2br( strtolower( $options->plugin('TextEditor')->buttons ) ) );
        $buttonConfigs = array_map('trim', $buttonConfigs);

        foreach( $buttonConfigs as $v )
        {
            $arr   = explode(',' , $v);
            $arr   = array_map('trim', $arr);
            $count = count($arr);

            if( $count > 1 )
            {
                $count == 2 ? $arr[] = '' : '';

                $buttonArr[] = '{ title : "' . current($arr) . '" , leftTag : "' . next($arr) . '" , rightTag : "' . next($arr) . '"}';
            }
        }
        $userButton = '[' . join($buttonArr, ',') . ']';


        echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"{$cssUrl}\" />";
        echo "<script type=\"text/javascript\" src=\"{$jsUrl}\"></script>";
        echo '<script type="text/javascript">
              window.addEvent("domready", function() {
                new TextEditorCore("text")
                    .setUserButton( '. $userButton .' )
                    .setHighlight("'. $options->plugin('TextEditor')->highlight .'")
                    .setSwfUploadConfig({
                        "flashUrl" : "';$options->adminUrl('javascript/swfupload/swfupload.swf');echo'" ,
                        "uploadUrl" : "';$options->index('/action/upload');echo'" ,
                        "postParams" : {
                                         "__typecho_uid" : "'.Typecho_Cookie::get('__typecho_uid').'" ,
                                         "__typecho_authCode" : "' . addslashes(Typecho_Cookie::get('__typecho_authCode')) .'"
                                        } ,
                        "sizeLimit" : "'.$val.' byte" ,
                        "fileTypes" : "'.$fileTypes.'",
                        "TypesDescription" : "'._t('所有文件').'"
                    })
                    .init("'.$baseDir.'");
              })
              </script>' ;


    }
}
