<?php
/**
 * 显示访客评论足迹
 * 
 * @package CommentTracks
 * @author 不烦恼
 * @version 1.0.0
 * @link http://bufannao.com
 */
class CommentTracks implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {}
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $comments = new Typecho_Widget_Helper_Form_Element_Text('comments', NULL, '10', _t('评论足迹数量'),  _t('默认显示访客评论足迹的数量'));
        $form->addInput($comments);
    }
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}
    
    /**
     * 插件实现方法(输出评论足迹)
     * 
     * @access public
     * @param array $comment 评论结构
     * @param Typecho_Widget $post 被评论的文章
     * @return void
     */
    public static function output($comments = 0)
    {
		$db = Typecho_Db::get();
		$track = Typecho_Widget::widget('Widget_Abstract_Comments@CommentTracks');

		if(empty( $comments))
		{
			$comments = Helper::options()->plugin('CommentTracks')->comments;
		}

		if($user = Typecho_Widget::widget('Widget_User') AND $user->hasLogin())
		{
			$mail = $user->mail;
		}
		else
		{
			$mail = Typecho_Cookie::get('__typecho_remember_mail');
		}

		$select  = $track->select()->limit((int)$comments)
		->where('table.comments.status = ?', 'approved')
		->where('table.comments.mail = ?', $mail)
		->order('table.comments.coid', Typecho_Db::SORT_DESC);

		$db->fetchAll($select, array($track, 'push'));
		return $track;
	}
}
