<?php
/**
 * Ckeditor+代码高亮显示
 * 自动集成语法高亮的编辑器，QFisH.Me美化版。
 * <br />( CKEditor + syntax-highlighter )
 *
 * @package Editor 
 * @author QFisH
 * @version 1.0.1
 * @dependence 9.9.2-*
 * @link http://QFisH.Me
 */
class Editor_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     * 
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
		Typecho_Plugin::factory('admin/write-post.php')->content = array('Editor_Plugin', 'ckfixHtml');
		Typecho_Plugin::factory('admin/write-page.php')->content = array('Editor_Plugin', 'ckfixHtml');
        Typecho_Plugin::factory('admin/write-post.php')->richEditor = array('Editor_Plugin', 'render');
        Typecho_Plugin::factory('admin/write-page.php')->richEditor = array('Editor_Plugin', 'render');
        
        //去除段落
        Typecho_Plugin::factory('Widget_Contents_Post_Edit')->write = array('Editor_Plugin', 'filter');
		Typecho_Plugin::factory('Widget_Contents_Page_Edit')->write = array('Editor_Plugin', 'filter');
		
		Typecho_Plugin::factory('Widget_Archive')->header = array('Editor_Plugin', 'header');
		Typecho_Plugin::factory('Widget_Archive')->footer = array('Editor_Plugin', 'footer');
    }
    
    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     * 
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate()
    {
    //    Helper::removePanel(0, 'TinyMCE/tiny_mce/langs.php');
    }
    
    /**
     * 获取插件配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
		$langs = array(		
			'shBrushAS3' => 'Actionscript',
			'shBrushBash' => 'Bash',
			'shBrushCpp' => 'C/C++',
			'shBrushCss' => "CSS",
			'shBrushCSharp' => 'CSharp',
			'shBrushColdFusion' => 'ColdFusion',
			'shBrushDelphi' => 'Delphi',
			'shBrushDiff' => 'Diff',
			'shBrushErlang' => 'Erlang',
			'shBrushGroovy' => 'Groovy',
			'shBrushPowerShell' => 'PowerShell',
			'shBrushScala' => 'Scala',
			'shBrushJava' => "Java",
			'shBrushJScript' => "Javascript",
			'shBrushPerl' => 'Perl',
			'shBrushPhp' => "PHP",
			'shBrushPython' => "Python",
			'shBrushRuby' => "Ruby",
			'shBrushSql' => "Sql",
			'shBrushVb' => "VB",
			'shBrushXml' => "XML/HTML",
		);		
        $mode = new Typecho_Widget_Helper_Form_Element_Radio('mode', array('1'=>_t('启用'), '0'=>_t('关闭')), '1', _t('语法高亮是否启用'));
		$highLang = new Typecho_Widget_Helper_Form_Element_Checkbox('highLang', $langs, array('shBrushXml', 'shBrushPhp', 'shBrushJScript'), _t('选择要高亮语法的语言'));
		$extendCss = new Typecho_Widget_Helper_Form_Element_Textarea('extendCss', NULL, _t("pre, code {display:inline;}"), _t('自定义样式(CSS)'));
       
		$form->addInput($mode);
        $form->addInput($highLang);
		$form->addInput($extendCss);
    }
    
    /**
     * 个人用户的配置面板
     * 
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}
    
	/**
     * 输出头部css
     * 
     * @access public
     * @param unknown $header
     * @return unknown
     */
    public static function header() 
	{
		
	}
    
	 /**
     * 输出尾部js
     * 
     * @access public
     * @param unknown $header
     * @return unknown
     */
    public static function footer() 
	{
        $options = Typecho_Widget::widget('Widget_Options');
        $opt = $options->plugin('Editor');
		if($opt->mode)
		{
			$cssUrl = Helper::options()->pluginUrl . '/Editor/syntaxhighlighter/styles/';
			echo '<link rel="stylesheet" type="text/css" href="' . $cssUrl . 'shCore.css" />'."\n";		
			echo '<link rel="stylesheet" type="text/css" href="' . $cssUrl . 'shThemeDefault.css" />'."\n";
			echo '<style type="text/css">' . $opt->extendCss . '.syntaxhighlighter .line td{line-height: 15px !important;}</style>'."\n";
			
			$jsUrl = Helper::options()->pluginUrl . '/Editor/syntaxhighlighter/scripts/';		
			echo '<script type="text/javascript" src="'. $jsUrl .'shCore.js"></script>'."\n";
			foreach($opt->highLang as $langScriptName)
			{
				echo '<script type="text/javascript" src="'. $jsUrl . $langScriptName . '.js"></script>'."\n";			
			}			
			echo '<script type="text/javascript">
					SyntaxHighlighter.config.clipboardSwf = "'. $jsUrl . 'clipboard.swf";' . "\n" . 'SyntaxHighlighter.all();
				  </script>'."\n";
		}
    }
	
	/**
     * 去除修正其他编辑器的标签问题
     * 
     * @access public
     * @param object $post 数据对象
     * @return void
     */
    public static function ckfixHtml($post)
    {
        $post->text = addslashes(Typecho_Common::cutParagraph($post->text));
		//调用编辑器
		echo "
		<script type=\"text/javascript\">
		document.getElementById(\"text\").innerHTML = '" . $post->text . "';
		</script> ";
    }
	
    /**
     * 去除段落
     * 
     * @access public
     * @param array $post 数据结构体
     * @return array
     */
    public static function filter($post)
    {
        $post['text'] = Typecho_Common::removeParagraph($post['text']);
        return $post;
    }
    
    /**
     * 实现方法
     * 
     * @access public
     * @param object $post 数据对象
     * @return void
     */
    public static function render($post)
    {
		$url = Typecho_Common::url('Editor/ckeditor', Helper::options()->pluginUrl);
		echo <<<EOT
<script language="javascript" type="text/javascript" src="{$url}/ckeditor.js"></script>
<script type="text/javascript">
		CKEDITOR.replace('text');
var insertImageToEditor = function (title, url, link) {
if ( CKEDITOR.instances.text.mode == 'wysiwyg' ) {
CKEDITOR.instances.text.insertHtml('<img src=\"' + url + '\" alt=\"' + title + '\" />') ;
}
else
{
	alert('请先转换到所见即所得模式') ;
}
};

var insertLinkToEditor = function (title, url, link) {
if ( CKEDITOR.instances.text.mode == 'wysiwyg' ) {
CKEDITOR.instances.text.insertHtml('<a href=\"' + url + '\" title=\"' + title + '\">' + title + '</a>') ;
}
else
{
	alert('请先转换到所见即所得模式') ;
}
};
</script>
EOT;
		echo <<<EOT
<script type="text/javascript">
function InsertHTML(value)
{
	// Get the editor instance that we want to interact with.
	var oEditor = CKEDITOR.instances.text;
	// Check the active editing mode.
	if (oEditor.mode == 'wysiwyg' )
	{
		// Insert the desired HTML.
		oEditor.insertHtml( value ) ;
	}
	else
		alert( '请先转换到所见即所得模式' ) ;
}
</script>
<script type="text/javascript">
var labels=document.getElementsByTagName("label");
for(i=0;i<labels.length;i++)
{
	if(labels[i].getAttributeNode("for").value=="tags")
	{
		labelText = labels[i].innerHTML;
		labels[i].innerHTML = labelText + " | <a href=\" http://qfish.me/2011/05/ckeditor-syntaxhighlighte.html\" title=\"CkHighlightEditor4Te插件更新\" target=\"_blank\";>编辑器更新</a>";
	}
}
</script>
EOT;
    }
}
